<?php
// config.php
define('BOT_TOKEN', '44090210:M12LYLCjzdNQkCKbNhAnhkPNidm7IyltyYF4UipO');
define('API_URL', 'https://tapi.bale.ai/bot' . BOT_TOKEN);

// ذخیره حالت کاربران در یک فایل JSON
function getUserState($chatId) {
    $file = 'user_states.json';
    if (!file_exists($file)) {
        file_put_contents($file, '{}');
    }
    $data = json_decode(file_get_contents($file), true);
    return isset($data[$chatId]) ? $data[$chatId] : null;
}

function setUserState($chatId, $state) {
    $file = 'user_states.json';
    $data = file_exists($file) ? json_decode(file_get_contents($file), true) : [];
    $data[$chatId] = $state;
    file_put_contents($file, json_encode($data));
}

// تابع ارسال پیام
function sendMessage($chatId, $text, $options = []) {
    $method = isset($options['method']) ? $options['method'] : 'sendMessage';
    unset($options['method']);
    
    $data = [
        'chat_id' => $chatId,
        'text' => $text,
        'parse_mode' => 'HTML'
    ] + $options;
    
    $options = [
        'http' => [
            'header' => "Content-Type: application/json\r\n",
            'method' => 'POST',
            'content' => json_encode($data)
        ]
    ];
    
    $context = stream_context_create($options);
    return file_get_contents(API_URL . '/' . $method, false, $context);
}

// پردازش دستورات
function handleCommand($chatId, $command, $messageText = '') {
    $userState = getUserState($chatId);

    switch ($command) {
        case '/start':
            sendMessage($chatId,
                "👋 سلام! به دستار هوشمند افق کوروش منطقه ۴ خوش آمدید!\n\nاز گزینه‌های زیر استفاده کنید:", [
                'reply_markup' => [
                    'inline_keyboard' => [
                        [['text' => "📢 از من بپرس", 'callback_data' => "/bepors"]],
                        [
                            ['text' => "📚 آموزش", 'callback_data' => "/learn"],
                            ['text' => "📝 نرم افزار", 'callback_data' => "/register"]
                        ],
                        [
                            ['text' => "☎️ تماس با ما", 'callback_data' => "/contact"],
                            ['text' => "📝  خبرنامه", 'callback_data' => "/register"]
                        ],
                        [['text' => "❓ راهنما", 'callback_data' => "/help"]]
                    ]
                ]
            ]);
            setUserState($chatId, 'main_menu');
            break;

        case '/help':
            sendMessage($chatId,
                "📚 لطفاً یکی از گزینه‌های زیر را انتخاب کنید:", [
                'reply_markup' => [
                    'inline_keyboard' => [
                        [
                            ['text' => "🚀 شروع", 'callback_data' => "/start"],
                            ['text' => "ℹ️ درباره ما", 'callback_data' => "/about"]
                        ],
                        [
                            ['text' => "❓ راهنما", 'callback_data' => "/help"],
                            ['text' => "📞 پشتیبانی", 'callback_data' => "/support"]
                        ]
                    ]
                ]
            ]);
            break;

        case '/learn':
            sendMessage($chatId,
                "📚 آموزش‌ها", [
                'reply_markup' => [
                    'inline_keyboard' => [
                        [
                            [
                                'text' => "📘 اتصال وای فای - سامان و ملت",
                                'url' => "https://ble.ir/okregion4/6866639063578086/1752736023106"
                            ]
                        ],
                        [
                            [
                                'text' => "📕 اتصال وای فای - ملی",
                                'url' => "https://ble.ir/okregion4/6404833123291412136/1752761682881"
                            ]
                        ],
                        [
                            [
                                'text' => "📘 آموزش اعلام نظر درباره جواب تیکت ثبت شده",
                                'url' => "https://ble.ir/okregion4/41930143026263440/1753005625655"
                            ]
                        ],
                        [
                            [
                                'text' => "📕 ارسال نامه با بیزاجی",
                                'url' => "https://ble.ir/okregion4/21187638530630330/1753005610584"
                            ]
                        ],
                        [
                            [
                                'text' => "📘 ارسال نامه با بیزاجی",
                                'url' => "https://ble.ir/okregion4/5619968606231066/1753006198610"
                            ]
                        ],
                        [
                            [
                                'text' => "📕 خطای اختلاف مبلغ بالای 150 هزار تومان در هنگام بستن صندوق",
                                'url' => "https://ble.ir/okregion4/149714147796157/1753005810302"
                            ]
                        ],
                        [
                            [
                                'text' => "📘 خروج از برنامه AX صندوق",
                                'url' => "https://ble.ir/okregion4/5495971089139345/1753005674588"
                            ]
                        ],
                        [
                            [
                                'text' => "📕 صندوق زدن با کالابرگ فارا (اعتبار یارانه)",
                                'url' => "https://ble.ir/okregion4/29008293087196412/1753006465639"
                            ]
                        ],
                        [
                            [
                                'text' => "📘 تسویه با مرکز کارتخوان برای گرفتن استعلام",
                                'url' => "https://ble.ir/okregion4/9451610990449346/1753006645676"
                            ]
                        ]
                    ]
                ]
            ]);
            break;

        case '/bepors':
            setUserState($chatId, 'bepors');
            sendMessage($chatId,
                "⁉️ من اینجام تا بهت بگم شرح وظایف هر واحد چی هست و از کجا پیگیری کنی، اینجوری مسیرت هموار میشه", [
                'reply_markup' => [
                    'inline_keyboard' => [
                        [
                            [
                                'text' => "📘 اتصال وای فای - سامان و ملت",
                                'url' => "https://ble.ir/okregion4/6866639063578086/1752736023106"
                            ]
                        ],
                        [
                            [
                                'text' => "📗 اتصال وای فای - ملی",
                                'url' => "https://ble.ir/okregion4/6404833123291412136/1752761682881"
                            ]
                        ]
                    ]
                ]
            ]);
            break;

        case '/contact':
            setUserState($chatId, 'bepors');
            sendMessage($chatId,
                "☎️ لطفا دیستریکت مورد نظر را انتخاب نمایید", [
                'reply_markup' => [
                    'inline_keyboard' => [
                        [
                            ['text' => "البرز A", 'callback_data' => "/contact-alborz-a"]
                        ],
                        [
                            ['text' => "البرز B", 'callback_data' => "/contact-alborz-b"],
                            ['text' => "البرز C", 'callback_data' => "/contact-alborz-c"],
                        ],
                        [
                            ['text' => "قزوین", 'callback_data' => "/contact-qazvin-a"],
                            ['text' => "قم", 'callback_data' => "/contact-qom-a"],
                        ],
                        [
                            ['text' => "🚨 آنکال واحد IT 🚨", 'callback_data' => "/ankal"],
                        ]
                    ]
                ]
            ]);
            break;

        case '/ankal':
            sendMessage($chatId,
                "🚨 <b>زمان بندی پاسخگویی شیفت آنکال واحد IT</b>\n\n" .
                "-------------------------------------------------------------------\n" .
                "🔸 شنبه تا چهارشنبه ساعت 17 الی 23\n" .
                "🔸 پنجشنبه از ساعت 12 الی 23\n" .
                "🔸 جمعه و روزهای تعطیل از ساعت 9 الی 23\n\n" .
                "<b>مواردی که در تایم شیفت رسیدگی می‌شود:</b>\n" .
                "🔹 قطعی ارتباط فروشگاه، صندوق یا سرور\n" .
                "🔹 مشکلات مربوط به فاکتور که باعث انتظار مشتری شود\n\n" .
                "<b>توجه:</b>\n" .
                "تمام مشکلات دیگر فقط در ساعات اداری رسیدگی می‌شود.\n" .
                "مشکلاتی از قبیل پرینتر، اسکنر، دوربین، اوتلوک و... جز در دو مورد ذکر شده، در ساعات اداری ثبت تیکت و پیگیری نمایید.\n\n" .
                "با تشکر از زحمات همکاران محترم 🌹",
            [
                'parse_mode' => "HTML",
                'reply_markup' => [
                    'inline_keyboard' => [
                        [
                            [
                                'text' => "📞 تماس با پشتیبانی",
                                'url' => "tel:093658878788"
                            ]
                        ]
                    ]
                ]
            ]);
            break;

        case '/contact-alborz-a':
            sendMessage($chatId,
                "<b>📞 لیست تماس با واحدهای مختلف</b>\n\n" .
                "<pre>" .
                "| نام                    | واحد                            | داخلی   |\n" .
                "--------------------------------------------------------------\n" .
                "خانم حبیبیان ➖ اینترنتی البرز ➖ 50485\n" .
                "خانم رحیمی ➖اینترنتی البرز ➖ 50479\n" .
                "خانم خاموشی ➖ بازاریابی البرز ➖ 50425\n" .
                "آقای قدیانلو ➖ بازاریابی البرز ➖ 50457\n" .
                "آقای عوض محمدی ➖ توسعه شعب البرز ➖ 50455\n" .
                "آقای خزائی ➖ بازاریابی قم ➖ 50419\n" .
                "خانم حیاتی ➖ بازرگانی ➖ 50422\n" .
                "آقای بهزادنیا ➖ برنامه ریزی البرز ➖ 50403\n" .
                "خانم حاتمی زینب ➖ برنامه ریزی البرز ➖ 50450\n" .
                "آقای نعمتی ➖ برنامه ریزی البرز ➖ 50469\n" .
                "آقای پوراصغر➖ تجهیز البرز ➖ 50402\n" .
                "آقای حیدری ➖ تجهیز البرز ➖ 50494\n" .
                "خانم امیری ➖ مالی البرز ➖ 50475\n" .
                "آقای یعقوبی ➖ توسعه شعب البرز ➖ 50473\n" .
                "آقای مرادیان ➖ توسعه شعب البرز ➖ 50459\n" .
                "آقای جعفری ➖ توسعه فروش البرز ➖ 50424\n" .
                "خانم حاتمی ➖ توسعه فروش البرز ➖ 50421\n\n" .
                "آقای مرادی ➖ فناوری اطلاعات قزوین زنجان ➖ 50418\n" .
                "آقای قاسمی ➖ فناوری اطلاعات قم اراک ➖ 50420\n" .
                "آقای کاکه خانی ➖ مالی البرز ➖ 50461\n" .
                "خانم عباسی ➖ مالی البرز ➖ 50453\n" .
                "خانم کاظمی ➖ مالی البرز ➖ 50474\n" .
                "خانم مهدوی ➖ منابع انسانی البرز ➖ 50463\n" .
                "خانم الموتی ➖ منابع انسانی البرز ➖ 50471\n" .
                "خانم سجادی ➖ منابع انسانی البرز ➖ 50470\n" .
                "آقای لاله ➖ منابع انسانی البرز ➖ 50492\n" .
                "آقای دانای طوس ➖ منابع انسانی البرز ➖ 50462\n" .
                "خانم فرهمند ➖ منابع انسانی البرز ➖ 50449\n" .
                "وحید خداداد ➖ منابع انسانی قم ➖ 50430\n" .
                "خانم شقاقی ➖ منابع انسانی قزوین ➖ 50489\n" .
                "آقای سجادی ➖ فروش سازمانی ➖ 50458\n" .
                "آقای جوانمردی➖ اداری ➖ 50428\n" .
                "خانم جعفری ➖ اداری ➖ 50486\n" .
                "آقای حاجی زاده ➖ اداری ➖ 50427\n" .
                "آقای معینی ➖ بازاریابی البرز➖ 50404\n" .
                "آقای صحراپور➖ مالی البرز➖ 50496\n" .
                "خانم آگاهی ➖ منابع انسانی البرز➖ 50465\n" .
                "خانم خاکپور ➖ منابع انسانی قزوین➖ 50501\n" .
                "خانم هنردار 🔸 منابع انسانی قزوین🔸50502\n\n" .
                "....................... واحد فناوری اطلاعات .......................\n" .
                "🔸آقای مفاخری ➖ 50416\n" .
                "🔸آقای عزیمی ➖ 50417\n" .
                "</pre>",
            ['parse_mode' => "HTML"]);
            break;
    }
}

// پردازش پیام‌های متنی
function handleTextMessage($chatId, $text) {
    $userState = getUserState($chatId);

    if ($userState === 'awaiting_name') {
        setUserState($chatId, 'awaiting_phone');
        file_put_contents("user_$chatId.name", $text);
        sendMessage($chatId, "✅ نام شما ثبت شد!\nلطفاً شماره تلفن خود را وارد کنید:");
    } elseif ($userState === 'awaiting_phone') {
        file_put_contents("user_$chatId.phone", $text);
        $name = file_get_contents("user_$chatId.name");
        setUserState($chatId, 'main_menu');
        sendMessage($chatId, "✅ ثبت‌نام با موفقیت انجام شد:\n\n👤 نام: $name\n📞 تلفن: $text");
    }
}

// پردازش Callback Query
function handleCallbackQuery($callbackQuery) {
    $chatId = $callbackQuery['message']['chat']['id'];
    $data = $callbackQuery['data'];

    if (strpos($data, '/') === 0) {
        handleCommand($chatId, $data, '');
        return;
    }

    if (strpos($data, 'product_') === 0) {
        $productId = explode('_', $data)[1];
        sendMessage($chatId, "محصول شماره $productId انتخاب شد!");
    }
}

// نقطه ورود اصلی
function processUpdate($update) {
    if (isset($update['message'])) {
        $message = $update['message'];
        $chatId = $message['chat']['id'];
        
        // اگر پیام فوروارد شده است
        if (isset($message['forward_from_chat'])) {
            $fromChat = $message['forward_from_chat'];
            $messageId = $message['message_id'];
            
            sendMessage($chatId,
                "✅ پست دریافت شد:\n\n" .
                "📢 from_chat_id: <b>" . ($fromChat['username'] ?? $fromChat['id']) . "</b>\n" .
                "🆔 message_id: <b>$messageId</b>");
        }
        
        // پردازش پیام متنی
        if (isset($message['text'])) {
            $text = $message['text'];
            
            if (strpos($text, '/') === 0) {
                $command = explode(' ', $text)[0];
                handleCommand($chatId, $command, $text);
            } else {
                handleTextMessage($chatId, $text);
            }
        }
    }
    
    // پردازش Callback Query
    if (isset($update['callback_query'])) {
        handleCallbackQuery($update['callback_query']);
    }
}

// دریافت به‌روزرسانی‌ها
$content = file_get_contents("php://input");
$update = json_decode($content, true);

if ($update) {
    processUpdate($update);
}

// پاسخ به وب‌هوک
echo 'OK';
?>